# Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
# See the included file LICENSE.txt for the licensing conditions.

QT += testlib
QT -= gui

CONFIG += qt console warn_on depend_includepath testcase
CONFIG -= app_bundle

TEMPLATE = app

linux:system("ls /usr/lib/x86_64-linux-gnu/libvisa.so"): CONFIG += linux_with_visa

INCLUDEPATH += \
	../include \
	../../THM1176InstrumentDriver/include \
	../../Common/SCPI/include \
	../../Common/Utility/include \
	../../Common/IEEE488Instrument/include \
	../../Common/USBTMCInstrument/include \
	../../Common/VISAInstrument/include \
	../../Common/eigen
macx:INCLUDEPATH += \
	/opt/local/include/libusb-1.0
linux:INCLUDEPATH += \
	/usr/local/include/libusb-1.0
win32:INCLUDEPATH += \
	../../Common/VISAInstrument/resources \
	../../Common/USBTMCInstrument/resources/libusb-1.0.22/include/libusb-1.0

VPATH += \
	../src \
	../../THM1176InstrumentDriver/src \
	../../Common/USBTMCInstrument/src
linux_with_visa|win32:VPATH += \
	../../Common/VISAInstrument/src

SOURCES +=  \
	CTHM1176InstrumentManager.cpp \
	THM1176.cpp \
	THM1176TypeConversions.cpp \
	THM1176Types.cpp \
	USBTMCInstrument.cpp \
	THM1176_imp.cpp
linux_with_visa|win32:SOURCES += \
	VISAInstrument.cpp

HEADERS += \
	../include/CTHM1176InstrumentManager.h

CONFIG(debug):DEFINES += _DEBUG

DEFINES += \
	THM1176_INSTRUMENT_TYPE_IS_USBTMC=1
linux_with_visa|win32:DEFINES += \
	THM1176_VISA_ENABLED=1 \
	ACTIVATE_READ_STB_WORKAROUND=1

macx:LIBS += \
#	-F/Library/Frameworks/ \
#	-framework VISA \
	/opt/local/lib/libusb-1.0.dylib
linux:LIBS += \
	-L/usr/local/lib \
	-lusb-1.0 -ludev
linux_with_visa:LIBS += \
	-L/usr/lib/x86_64-linux-gnu \
	-lvisa
win32:LIBS += \
	../../Common/VISAInstrument/resources/visa64.lib \
	../../Common/USBTMCInstrument/resources/libusb-1.0.22/MS64/dll/libusb-1.0.lib
