# Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
# See the included file LICENSE.txt for the licensing conditions.

GOOGLETEST_DIR = ../../Common/googletest-release-1.8.1
include(gtest_dependency.pri)

TEMPLATE = app
CONFIG += console c++11
CONFIG -= app_bundle
CONFIG += thread
CONFIG -= qt

linux:system("ls /usr/lib/x86_64-linux-gnu/libvisa.so"): CONFIG += linux_with_visa

INCLUDEPATH += \
	../include \
	../../Common/SCPI/include \
	../../Common/Utility/include \
	../../Common/IEEE488Instrument/include \
	../../Common/USBTMCInstrument/include \
	../../Common/VISAInstrument/include \
	../../Common/eigen
macx:INCLUDEPATH += \
	/usr/local/include/libusb-1.0
linux:INCLUDEPATH += \
	/usr/local/include/libusb-1.0
win32:INCLUDEPATH += \
	../../Common/VISAInstrument/resources \
	../../Common/USBTMCInstrument/resources/libusb-1.0.23/include/libusb-1.0

VPATH += \
	../src \
	../../Common/USBTMCInstrument/src
linux_with_visa|win32:VPATH += \
	../../Common/VISAInstrument/src

SOURCES += \
	main.cpp \
	THM1176.cpp \
	THM1176TypeConversions.cpp \
	THM1176Types.cpp \
	USBTMCInstrument.cpp \
	THM1176_imp.cpp \
	THM1176TestUtilities.cpp
linux_with_visa|win32:SOURCES += \
	VISAInstrument.cpp

HEADERS += \
	CTHM1176BasicsTest.cpp \
	CTHM1176ConnectTest.cpp \
	CTHM1176FileAccessTest.cpp \
	CTHM1176GetUtilitiesTest.cpp \
	CTHM1176HighLevelMeasurementsTest.cpp \
	CTHM1176InitiateTest.cpp \
	CTHM1176MeasurementsTest.cpp \
	CTHM1176MiscUtilitiesTest.cpp \
	CTHM1176SetGetParametersTest.cpp \
	CTHM1176StatusTest.cpp \
	CTHM1176TimeoutHandlingTest.cpp

CONFIG(debug):DEFINES += _DEBUG

DEFINES += \
	THM1176_INSTRUMENT_TYPE_IS_USBTMC=1
linux_with_visa|win32:DEFINES += \
	THM1176_VISA_ENABLED=1 \
	ACTIVATE_READ_STB_WORKAROUND=1

macx:LIBS += \
#	-F/Library/Frameworks/ \
#	-framework VISA \
	/usr/local/lib/libusb-1.0.dylib
linux:LIBS += \
	-L/usr/local/lib \
	-lusb-1.0 -ludev
linux_with_visa:LIBS += \
	-L/usr/lib/x86_64-linux-gnu \
	-lvisa
win32:LIBS += \
	../../Common/VISAInstrument/resources/visa64.lib \
	../../Common/USBTMCInstrument/resources/libusb-1.0.23/MS64/dll/libusb-1.0.lib
