// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Test THM1176 API: Connect, Disconnect

#include "gtest/gtest.h"
#include "THM1176TestUtilities.h"
#include "THM1176TypeConversions.h"

using namespace MTL::Instrument;
using namespace MTL::Instrument::THM1176Types;

/// \brief Test THM1176 API: Connect, Disconnect
class CTHM1176ConnectTest : public ::testing::Test
{
protected:
	THM1176_TEST_RESOURCE_MANAGER_CLASS	ResourceManager;
	tResourceName						THM1176;
	static const U32					THM1176_TIMEOUT = 5000;	// ms
	
	virtual void SetUp()
	{
		ASSERT_EQ(true, FetchTHM1176Resource(ResourceManager, THM1176));
	}
};

/// \test Test connect and disconnect.
TEST_F(CTHM1176ConnectTest, ConnectDisconnect)
{
	CTHM1176Instrument<THM1176_TEST_INSTRUMENT_CLASS, THM1176_TEST_RESOURCE_MANAGER_CLASS> l_THM1176(ResourceManager, THM1176);
	ASSERT_EQ(true, l_THM1176.Connect(THM1176_TIMEOUT));
	ASSERT_EQ(true, l_THM1176.IsOpen());
	l_THM1176.Disconnect();
	ASSERT_EQ(false, l_THM1176.IsOpen());
}

