// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Instantiations of THM1176 class template
///         for CVISAInstrument and CUSBTMCInstrument.

#include "THM1176.h"
#include "../src/THM1176.cpp"

#if (THM1176_INSTRUMENT_TYPE_IS_VISA)
    #include "VISAInstrument.h"
	template class MTL::Instrument::CTHM1176Instrument<MTL::Instrument::CVISAInstrument, MTL::Instrument::CVISAResourceManager>;
#endif

#if (THM1176_INSTRUMENT_TYPE_IS_USBTMC)
    #include "USBTMCInstrument.h"
    template class MTL::Instrument::CTHM1176Instrument<MTL::Instrument::CUSBTMCInstrument, MTL::Instrument::CUSBTMCResourceManager>;
#endif
