// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Type conversion routines for C++ API for Metrolab THM1176/TFM1186.

#pragma once

// Standard includes
#include <string>
#include <vector>
#include <regex>

// Personal includes
#include "THM1176Types.h"

namespace MTL {
	namespace Instrument {
		namespace THM1176Types {
			
			//----------------------------------------------------------------------//
			//							Conversion Utilities						//
			//----------------------------------------------------------------------//
			U16 BinaryToU16(const char pBinary[2]);	///< Convert binary to U16 (unimplemented).
			I16 BinaryToI16(const char pBinary[2]);	///< Convert binary to I16, taking into account endedness.
			U32 BinaryToU32(const char pBinary[4]);	///< Convert binary to U32 (unimplemented).
			I32 BinaryToI32(const char pBinary[4]);	///< Convert binary to I32, taking into account endedness.
			F32 BinaryToF32(const char pBinary[4]);	///< Convert binary to F32 (unimplemented).
			U64 BinaryToU64(const char pBinary[8]);	///< Convert binary to U64 (unimplemented).
			F64 BinaryToF64(const char pBinary[8]);	///< Convert binary to F64 (unimplemented).
			
			/// \brief Convert measurement units from string to enumeration.
			/// \param[in]	SUnits	Measurement units as a string.
			/// \param[out]	rUnits	Measurement units as an enumeration.
			/// \return True if successful.
			bool StringToUnits(std::string SUnits, eUnits & rUnits);
			
			/// \brief Convert measurement units from enumeration to string.
			/// \param[in]	Units	Measurement units as an enumeration.
			/// \return Corresponding string.
			std::string UnitsToString(eUnits Units);
			
			/// \brief Test the conversion routines.
			/// \return True if successful.
			bool TestTHM1176Types();
			
		} // namespace THM1176Types
	} // namespace Instrument
} // namespace MTL
