// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Utility functions used to test THM1176 API.

#pragma once

#include "THM1176.h"

#if (THM1176_INSTRUMENT_TYPE_IS_VISA)
	#define THM1176_TEST_RESOURCE_MANAGER_CLASS	CVISAResourceManager
	#define THM1176_TEST_INSTRUMENT_CLASS		CVISAInstrument
	#define THM1176_TEST_RESOURCE_FILTER		"USB[0-9]*::0x1BFA::0x0498::[0-9]+::INSTR"
	#include "VISAInstrument.h"
#elif (THM1176_INSTRUMENT_TYPE_IS_USBTMC)
	#define THM1176_TEST_RESOURCE_MANAGER_CLASS	CUSBTMCResourceManager
	#define THM1176_TEST_INSTRUMENT_CLASS		CUSBTMCInstrument
	#define THM1176_TEST_RESOURCE_FILTER		"7162:1176"
	#include "USBTMCInstrument.h"
#else
	#error "One of THM1176_TEST_INSTRUMENT_TYPE_IS_VISA or ..._USBTMC must be defined"
#endif

using namespace MTL::Instrument;
using namespace MTL::Instrument::THM1176Types;

/// \brief Open a connection to the Resource Manager and find a THM1176.
/// \param[in]	rResourceManager	Resource Manager
/// \param[out]	rTHM1176			Resource name of first THM1176 found
/// \return True if successful.
bool FetchTHM1176Resource (THM1176_TEST_RESOURCE_MANAGER_CLASS & rResourceManager, tResourceName & rTHM1176);

/// \brief Connect to a THM1176.
///
/// Start Resource Manager, call FetchTHM1176Resource, create THM1176 object, and connect to THM1176.
/// \param[out]    rpResourceManager	Pointer to Resource Manager object.
/// \param[out]    rpTHM1176			Pointer to THM1176 object.
/// \return True if successful.
bool ConnectToTHM1176 (THM1176_TEST_RESOURCE_MANAGER_CLASS	* & rpResourceManager, CTHM1176Instrument<THM1176_TEST_INSTRUMENT_CLASS, THM1176_TEST_RESOURCE_MANAGER_CLASS> * & rpTHM1176);

