// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Interface definition for VISAInstrument QtTest object.

#pragma once

// Qt includes
#include <QtTest/QtTest>

// Personal includes
#include "VISAInstrument"

using namespace MTL::Instrument;

/// \brief Test the VISAInstrument class.
class TestVISAInstrument : public QObject
{
	Q_OBJECT					///< Qt object.

private:
	CVISAResourceManager	m_RM;

private slots:
	// Mandatory
	void initTestCase();			///< Initialize test cases.
	void cleanupTestCase();			///< Clean up test cases.

	// Resource manager tests
	void FindResources();			///< Test FindResources.
	void FindResourcesWithFilter();	///< Test FindResourcesWithFilter.
	void ResourceInfo();			///< Test retrieving resource information.

	// VISA instrument basic communication
	void QueryIDN();				///< Test basic communication with instrument.
};
