//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Platform Dependent Definitions.
// See https://blog.kowalczyk.info/article/j/guide-to-predefined-macros-in-c-compilers-gcc-clang-msvc-etc..html

#pragma once

#ifdef _WIN32

	// Definitions
	#define MTL__FUNCTION_NAME__			__FUNCTION__
	#define MTL__FUNCTION_SIGNATURE__		__FUNCSIG__

#elif defined(__GNUC__) || defined(__APPLE__)

	// Definitions
	#define MTL__FUNCTION_NAME__			__FUNCTION__
	#define MTL__FUNCTION_SIGNATURE__		__PRETTY_FUNCTION__

#endif

//----------------------------------------------------------------------//
//							Basic Types									//
//----------------------------------------------------------------------//
typedef	char				I8;		///< \brief Signed byte.
typedef short				I16;	///< \brief 16-bit signed integer.
typedef int					I32;	///< \brief 32-bit signed integer.
typedef long long			I64;	///< \brief 64-bit signed integer.
typedef unsigned char		U8;		///< \brief Unsigned byte.
typedef unsigned short		U16;	///< \brief 16-bit unsigned integer.
typedef unsigned int		U32;	///< \brief 32-bit unsigned integer.
typedef unsigned long long	U64;	///< \brief 64-bit unsigned integer.
typedef float				F32;	///< \brief 32-bit floating-point number.
typedef double				F64;	///< \brief 64-bit floating-point number.
