#include "libusb.h"
#include <iostream>

int main(int argc, char *argv[])
{
    // Initialize libusb.
    libusb_context * l_pContext;
    int l_Status = libusb_init (&l_pContext);
    if (l_Status != LIBUSB_SUCCESS)
    {
        std::cout << "libusb_init error: " << l_Status << "\n";
        exit (1);
    }

    // Set the log level.
    l_Status = libusb_set_option (l_pContext, LIBUSB_OPTION_LOG_LEVEL, LIBUSB_LOG_LEVEL_WARNING);
    if (l_Status != LIBUSB_SUCCESS)
    {
        std::cout << "libusb_set_option error: " << l_Status << "\n";
        exit (1);
    }

    l_Status = libusb_has_capability(LIBUSB_CAP_HAS_HOTPLUG);
    std::cout << "libusb_has_capability(LIBUSB_CAP_HAS_HOTPLUG) returns: " << l_Status << "\n";
    exit (0);
}
