// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Interface definition for SCPI QtTest object.

#pragma once

// Qt includes
#include <QtTest/QtTest>

/// \brief Test the %SCPI parsing functions.
class TestSCPIParsing : public QObject
{
	Q_OBJECT					///< Qt object.

private slots:
	// Mandatory
	void initTestCase();		///< Initialize test cases.
	void cleanupTestCase();		///< Clean up test cases.

	// Test cases
	void ArbitraryBlock();		///< Test arbitrary-block functions.
	void StringChannelList();	///< Test string channel list functions.
	void BinaryChannelList();	///< Test binary channel list functions.
};
