// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Test IEEE488 Resource Manager: FindResources, Status, StatusDescription methods.

#pragma once

#include <gtest/gtest.h>

#include "IEEE488InstrumentTest.h"

using namespace testing;

class IEEE488ResourceManagerTest : public ::testing::Test
{
protected:
    static IEEE4888_TEST_RESOURCE_MANAGER_CLASS *	pResourceManager;

    static void SetUpTestCase()
    {
        pResourceManager = new IEEE4888_TEST_RESOURCE_MANAGER_CLASS;
        ASSERT_NE(nullptr, pResourceManager);
        ASSERT_EQ(true, pResourceManager->Initialize());
    }

    static void TearDownTestCase()
    {
        delete pResourceManager;
        pResourceManager = nullptr;
    }
};

IEEE4888_TEST_RESOURCE_MANAGER_CLASS *  IEEE488ResourceManagerTest::pResourceManager    = nullptr;

/// \brief Test FindResources by calling it repeatedly and dumping the output.
/// Note: to see the output in Qt Creator, click on the ">_￼ (Switch Between Visual and Text Display)"
/// button in the Test Results output pane.
TEST_F(IEEE488ResourceManagerTest, FindResourcesDuringOneMinute)
{
    std::chrono::system_clock::time_point l_EndTime = std::chrono::system_clock::now() + std::chrono::minutes(1);
    while (std::chrono::system_clock::now() < l_EndTime)
    {
        CResourceList l_ResourceList;
        ASSERT_EQ(true, pResourceManager->FindResources(l_ResourceList, IEEE4888_TEST_RESOURCE_FILTER));
        std::cout << l_ResourceList.Dump();

        std::cout << "Status: " << pResourceManager->StatusDescription(pResourceManager->Status()) << std::endl << std::endl;

        std::this_thread::sleep_for(std::chrono::seconds(1));
    }
}
