# Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
# See the included file LICENSE.txt for the licensing conditions.

GOOGLETEST_DIR = ../../googletest-release-1.11.0
include(gtest_dependency.pri)

TEMPLATE = app
CONFIG += console c++11
CONFIG -= app_bundle
CONFIG += thread
CONFIG -= qt

linux:system("ls /usr/lib/x86_64-linux-gnu/libvisa.so"): CONFIG += linux_with_visa

INCLUDEPATH += \
	../include \
	../../SCPI/include \
	../../Utility/include \
	../../USBTMCInstrument/include \
	../../VISAInstrument/include \
	../../VXI11Instrument/include \
	../../VXI11Instrument/rpcl
macx:INCLUDEPATH += \
	/usr/local/include/libusb-1.0
linux:INCLUDEPATH += \
	/usr/local/include/libusb-1.0 \
	/usr/include/glib-2.0 \
	/usr/lib/x86_64-linux-gnu/glib-2.0/include
win32:INCLUDEPATH += \
	../../VXI11Instrument/resources/oncrpc/win32/include \
	../../VISAInstrument/resources \
	../../USBTMCInstrument/resources/libusb-1.0.23/include/libusb-1.0

VPATH += \
	../../USBTMCInstrument/src \
	../../VXI11Instrument/src \
	../../VXI11Instrument/rpcl
win32|linux_with_visa:VPATH += \
	../../VISAInstrument/src

SOURCES += \
	main.cpp \
	IEEE488InstrumentTest.cpp \
	USBTMCInstrument.cpp \
	VXI11Instrument.cpp \
	VXI11BroadcastDiscovery.c \
	VXI11InstrumentList.c \
	VXI11InstrumentRegistry.c \
	VXI11Regex.cpp \
	VXI11_client.c \
	VXI11_xdr.c
mac:SOURCES += \
	VXI11DiscoveryMac.c
linux:SOURCES += \
	VXI11DiscoveryLinux.c
win32:SOURCES += \
	VXI11DiscoveryWindows.c
win32|linux_with_visa:SOURCES += \
	VISAInstrument.cpp

HEADERS += \
	USBTMCIntrument.h \
	VXI11Instrument.h \
	VXI11BroadcastDiscovery.h  \
	VXI11InstrumentRegistry.h \
	VXI11Discovery.h \
	VXI11InstrumentList.h \
	VXI11Regex.h \
	VXI11.h \
	IEEE488InstrumentTest.h \
	IEEE488ResourceManagerTest.h \
	IEEE488InstrumentOpenCloseTest.h \
	IEEE488InstrumentReadWriteTest.h \
	IEEE488InstrumentMiscUtilitiesTest.h \
	IEEE488InstrumentInterruptTest.h
win32|linux_with_visa:HEADERS += \
	VISAInstrument.h \
	VISAInstrumentTypes.h

CONFIG(debug):DEFINES += _DEBUG
win32:DEFINES += _CRT_SECURE_NO_WARNINGS

win32|linux_with_visa:DEFINES += \
	ACTIVATE_READ_STB_WORKAROUND=1

macx:LIBS += \
	-F/Library/Frameworks/ \
	/usr/local/lib/libusb-1.0.dylib
linux:LIBS += \
	-L/usr/local/lib \
	-lusb-1.0 \
	-ludev \
	-lpthread \
	-lavahi-glib \
	-lavahi-client \
	-lavahi-common \
	-lglib-2.0
linux_with_visa:LIBS += \
	-L/usr/lib/x86_64-linux-gnu \
	-lvisa
win32:LIBS += \
	ws2_32.lib \
	Iphlpapi.lib \
	../../VISAInstrument/resources/visa64.lib \
	../../USBTMCInstrument/resources/libusb-1.0.23/MS64/dll/libusb-1.0.lib
win32:CONFIG(debug):LIBS += ../../VXI11Instrument/resources/oncrpc/win32/librpc/lib/Debug/oncrpc.lib
win32:!CONFIG(debug):LIBS += ../../VXI11Instrument/resources/oncrpc/win32/librpc/lib/Release/oncrpc.lib

