// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Utility functions used to test IEEE488Instrument API.

#pragma once

#include "IEEE488Instrument.h"

#if (INSTRUMENT_TYPE_IS_USBTMC)
    #define IEEE4888_TEST_RESOURCE_MANAGER_CLASS	CUSBTMCResourceManager
    #define IEEE4888_TEST_INSTRUMENT_CLASS          CUSBTMCInstrument
    #define IEEE4888_TEST_RESOURCE_FILTER           "7162:1176"
    #include "USBTMCInstrument.h"
#elif (INSTRUMENT_TYPE_IS_VISA)
    #define IEEE4888_TEST_RESOURCE_MANAGER_CLASS	CVISAResourceManager
    #define IEEE4888_TEST_INSTRUMENT_CLASS          CVISAInstrument
    #define IEEE4888_TEST_RESOURCE_FILTER           "USB[0-9]*::0x1BFA::0x0498::[0-9]+::INSTR"
    #include "VISAInstrument.h"
#elif (INSTRUMENT_TYPE_IS_VXI11)
    #define IEEE4888_TEST_RESOURCE_MANAGER_CLASS	CVXI11ResourceManager
    #define IEEE4888_TEST_INSTRUMENT_CLASS          CVXI11Instrument
    #define IEEE4888_TEST_RESOURCE_FILTER           ".*"
    #include "VXI11Instrument.h"
#else
    #error "One of TEST_INSTRUMENT_TYPE_IS_VISA or ..._USBTMC must be defined"
#endif

using namespace MTL::Instrument;

/// \brief Open a connection to the Resource Manager and find an IEEE488Instrument.
/// \param[in]	rResourceManager        Resource Manager
/// \param[out]	rInstrumentName         Resource Name of first IEEE488Instrument found
/// \return True if successful.
bool FetchIEEE4888Resource (IEEE4888_TEST_RESOURCE_MANAGER_CLASS & rResourceManager, tResourceName & rInstrumentName);

/// \brief Connect to an IEEE488Instrument.
///
/// Start Resource Manager, call FetchIEEE4888Resource, create IEEE488Instrument object, and connect to IEEE488Instrument.
/// \param[out]    rpResourceManager	Pointer to Resource Manager object.
/// \param[out]    rpIEEE488Instrument  Pointer to IEEE488Instrument object.
/// \return True if successful.
bool ConnectToIEEE488Instrument (IEEE4888_TEST_RESOURCE_MANAGER_CLASS * & rpResourceManager, IEEE4888_TEST_INSTRUMENT_CLASS * & rpIEEE488Instrument);

/// \brief Sanity-check of the response to an *IDN? query.
/// \param[in]      rBuffer             Response to *IDN? query.
/// \return True if successful.
bool CheckIDNResponse (const CSCPIBuffer &rBuffer);
