// Copyright (c) 2020 Metrolab Technology S.A., Geneva, Switzerland (www.metrolab.com)
// See the included file LICENSE.txt for the licensing conditions.

//////////////////////////////////////////////////////////////////////////
/// \file
/// \brief Abstract IEEE488 instrument class: type definitions.

#pragma once

// Standard libraries
#include <string>
#include <vector>
#include <iostream>

namespace MTL
{
	namespace Instrument
	{
		//----------------------------------------------------------------------//
		//							Resource names								//
		//----------------------------------------------------------------------//
		typedef std::string		tResourceName;			///< IEEE488 resource name.

		/// \brief List of VISA resource names
		class CResourceList : public std::vector<tResourceName>
		{
		public:
			std::string Dump() const
			{
				std::string l_RsrcList;
				for (CResourceList::const_iterator it = this->begin(); it != this->end(); it++)
					l_RsrcList += *it + '\n';
				return l_RsrcList;
			}											///< Dump the VISA resource list into a string.
			bool operator==(CResourceList const & other)
			{
				if (other.size() != size())
					return false;
				for (CResourceList::const_iterator thisit = begin(), otherit = other.begin(); thisit != end(); thisit++, otherit++)
				{
					if (*thisit != *otherit)
						return false;
				}
				return true;
			}											///< Equality operator.
			bool operator!=(CResourceList const & other)
			{
				if (other.size() != size())
					return true;
				for (CResourceList::const_iterator thisit = begin(), otherit = other.begin(); thisit != end(); thisit++, otherit++)
				{
					if (*thisit != *otherit)
						return true;
				}
				return false;
			}											///< Inequality operator.
		};

	}
}	// namespace MTL::Instrument
